<?php
include('config.php');

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $invoice_no = $_POST['invoice_no'];
    $stock_in_date = $_POST['stock_in_date'];
    $supplier_id = $_POST['supplier_id'];
    $medicine_id = $_POST['medicine_id'];
    $batch_number = $_POST['batch_number'];
    $manufacture_date = $_POST['manufacture_date'];
    $expiry_date = $_POST['expiry_date'];
    $quantity = $_POST['quantity'];
    $purchase_rate = $_POST['purchase_rate'];
    $selling_rate = $_POST['selling_rate'];
    $gst_percent = $_POST['gst_percent'];
    $storage_location = $_POST['storage_location'];
    $added_by = $_SESSION['username']; // Must be set on login

    $gst_amount = ($purchase_rate * $quantity) * ($gst_percent / 100);
    $total_cost = ($purchase_rate * $quantity) + $gst_amount;

    $stmt = $conn->prepare("INSERT INTO stock_in (invoice_no, stock_in_date, supplier_id, medicine_id, batch_number, manufacture_date, expiry_date, quantity, purchase_rate, selling_rate, gst_percent, total_cost, storage_location, added_by)
    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
    $stmt->bind_param("ssiiissiidddss", $invoice_no, $stock_in_date, $supplier_id, $medicine_id, $batch_number, $manufacture_date, $expiry_date, $quantity, $purchase_rate, $selling_rate, $gst_percent, $total_cost, $storage_location, $added_by);
    
    if ($stmt->execute()) {
        echo "<script>alert('Stock In Saved Successfully');</script>";
    } else {
        echo "<script>alert('Error Saving Stock');</script>";
    }
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Stock In</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <script>
    function calculateTotal() {
        let quantity = parseFloat(document.getElementById('quantity').value) || 0;
        let rate = parseFloat(document.getElementById('purchase_rate').value) || 0;
        let gst = parseFloat(document.getElementById('gst_percent').value) || 0;
        let total = (quantity * rate) + ((quantity * rate) * (gst / 100));
        document.getElementById('total_cost').value = total.toFixed(2);
    }
    </script>
</head>
<body class="container mt-5">
    <h3>Stock In Entry</h3>
    <form method="post">
        <div class="row mb-3">
            <div class="col">
                <label>Invoice No</label>
                <input type="text" name="invoice_no" class="form-control" required>
            </div>
            <div class="col">
                <label>Stock In Date</label>
                <input type="date" name="stock_in_date" class="form-control" required>
            </div>
        </div>

        <div class="row mb-3">
            <div class="col">
                <label>Supplier Name</label>
                <select name="supplier_id" class="form-control" required>
                    <option value="">Select Supplier</option>
                    <?php
                    $suppliers = $conn->query("SELECT * FROM vendor_masters");
                    while ($row = $suppliers->fetch_assoc()) {
                        echo "<option value='{$row['id']}'>{$row['supplier_name']}</option>";
                    }
                    ?>
                </select>
            </div>
            <div class="col">
                <label>Medicine Name</label>
                <select name="medicine_id" class="form-control" required>
                    <option value="">Select Medicine</option>
                    <?php
                    $medicines = $conn->query("SELECT * FROM medicines");
                    while ($row = $medicines->fetch_assoc()) {
                        echo "<option value='{$row['id']}'>{$row['medicine_name']}</option>";
                    }
                    ?>
                </select>
            </div>
        </div>

        <div class="row mb-3">
            <div class="col">
                <label>Batch Number</label>
                <input type="text" name="batch_number" class="form-control" required>
            </div>
            <div class="col">
                <label>Manufacture Date</label>
                <input type="date" name="manufacture_date" class="form-control" required>
            </div>
            <div class="col">
                <label>Expiry Date</label>
                <input type="date" name="expiry_date" class="form-control" required>
            </div>
        </div>

        <div class="row mb-3">
            <div class="col">
                <label>Quantity</label>
                <input type="number" name="quantity" id="quantity" class="form-control" required oninput="calculateTotal()">
            </div>
            <div class="col">
                <label>Purchase Rate</label>
                <input type="number" step="0.01" name="purchase_rate" id="purchase_rate" class="form-control" required oninput="calculateTotal()">
            </div>
            <div class="col">
                <label>Selling Rate / MRP</label>
                <input type="number" step="0.01" name="selling_rate" class="form-control" required>
            </div>
        </div>

        <div class="row mb-3">
            <div class="col">
                <label>GST %</label>
                <input type="number" step="0.01" name="gst_percent" id="gst_percent" class="form-control" required oninput="calculateTotal()">
            </div>
            <div class="col">
                <label>Total Cost</label>
                <input type="text" name="total_cost" id="total_cost" class="form-control" readonly>
            </div>
            <div class="col">
                <label>Storage Location</label>
                <input type="text" name="storage_location" class="form-control" required>
            </div>
        </div>

        <button class="btn btn-primary">Save Stock</button>
    </form>
</body>
</html>
